unit Ledlp_7a;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Buttons, ExtCtrls, Ledlp;

type
  TForm1 = class(TForm)
    LEdit1: TLEdit;
    Panel1: TPanel;
    FileButton: TSpeedButton;
    OptionsButton: TSpeedButton;
    FilePopupMenu: TPopupMenu;
    OptionsPopupMenu: TPopupMenu;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    HighlightTags: TMenuItem;
    Font1: TMenuItem;
    ForegroundColor1: TMenuItem;
    BackgroundColor1: TMenuItem;
    OpenDialog1: TOpenDialog;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    TagsForegroundColor1: TMenuItem;
    TagsBackgroundColor1: TMenuItem;
    procedure FileButtonClick(Sender: TObject);
    procedure OptionsButtonClick(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure ForegroundColor1Click(Sender: TObject);
    procedure BackgroundColor1Click(Sender: TObject);
    procedure HighlightTagsClick(Sender: TObject);
    procedure LEdit1ControlHighlight(Sender: TObject; WordType: Word;
      WordValue: Longint; WordStr: String; var ForeClr, BackClr: TColor);
    procedure TagsForegroundColor1Click(Sender: TObject);
    procedure TagsBackgroundColor1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FTagForeColor: TColor;
    FTagBackColor: TColor;
    HTMLScript: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FileButtonClick(Sender: TObject);
var
  MenuX, MenuY: Integer;
begin
  MenuX := (Form1.Left + FileButton.Left + 4);
  MenuY := ((Form1.Top + FileButton.Top) + (FileButton.Height + 22));
  FilePopupMenu.Popup(MenuX, MenuY);
end;

procedure TForm1.OptionsButtonClick(Sender: TObject);
var
  MenuX, MenuY: Integer;
begin
  MenuX := (Form1.Left + OptionsButton.Left + 4);
  MenuY := ((Form1.Top + OptionsButton.Top) + (OptionsButton.Height + 22));
  OptionsPopupMenu.Popup(MenuX, MenuY);
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  LEdit1.NewFile;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    LEdit1.LoadFromFile(OpenDialog1.FileName);
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  LEdit1.SaveFile;
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  LEdit1.SaveFileAs;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  FontDialog1.Font := LEdit1.Font;
  if FontDialog1.Execute then
  begin
    LEdit1.Font := FontDialog1.Font;
  end;
end;

procedure TForm1.ForegroundColor1Click(Sender: TObject);
begin
  ColorDialog1.Color := LEdit1.Font.Color;
  if ColorDialog1.Execute then
  begin
    LEdit1.Font.Color := ColorDialog1.Color;
  end;
end;

procedure TForm1.BackgroundColor1Click(Sender: TObject);
begin
  ColorDialog1.Color := LEdit1.Color;
  if ColorDialog1.Execute then
  begin
    LEdit1.Color := ColorDialog1.Color;
  end;
end;

procedure TForm1.HighlightTagsClick(Sender: TObject);
begin
  if HighlightTags.Checked then
  begin
    HighlightTags.Checked := False;
    LEdit1.Highlight := False;
    LEdit1.Invalidate;
  end
  else
  begin
    HighlightTags.Checked := True;
    LEdit1.Highlight := True;
    LEdit1.Invalidate;
  end;
end;

procedure TForm1.LEdit1ControlHighlight(Sender: TObject; WordType: Word;
  WordValue: Longint; WordStr: String; var ForeClr, BackClr: TColor);
begin
  ForeClr := FTagForeColor;
  BackClr := FTagBackColor;
  LEdit1.MsgResult := 3;
end;

procedure TForm1.TagsForegroundColor1Click(Sender: TObject);
begin
  ColorDialog1.Color := FTagForeColor;
  if ColorDialog1.Execute then
  begin
    FTagForeColor := ColorDialog1.Color;
  end;
  LEdit1.Invalidate;
end;

procedure TForm1.TagsBackgroundColor1Click(Sender: TObject);
begin
  ColorDialog1.Color := FTagBackColor;
  if ColorDialog1.Execute then
  begin
    FTagBackColor := ColorDialog1.Color;
  end;
  LEdit1.Invalidate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FTagForeColor := clBlue;
  FTagBackColor := clWindow;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
{  LEdit1.MultiLineItems := True;
  LEdit1.StartInComments := True;}
end;

end.
